'use strict';

/**
 * Objeto Asuntos Acadmicos UNSM
 * Maneja la funcionalidad especfica de la pgina de Asuntos Acadmicos
 */
const AsuntosAcademicos = {
    // ============================================
    // ESTADO DE LA APLICACIN
    // ============================================
    state: {
        currentTab: 'funciones'
    },

    // ============================================
    // INICIALIZACIN
    // ============================================
    init() {
        try {
            console.log('========================================');
            console.log('= INICIANDO MDULO ASUNTOS ACADMICOS');
            console.log('========================================');

            this.initTabs();
            console.log(' Sistema de tabs inicializado');

            console.log('========================================');
            console.log(' MDULO ASUNTOS ACADMICOS CARGADO');
            console.log('========================================');
        } catch (error) {
            console.error('L Error durante la inicializacin de Asuntos Acadmicos:', error);
        }
    },

    // ============================================
    // SISTEMA DE TABS
    // ============================================
    initTabs() {
        const tabButtons = document.querySelectorAll('.tab-button');
        const tabContents = document.querySelectorAll('.tab-content');

        if (tabButtons.length === 0) {
            console.warn(' No se encontraron botones de tabs');
            return;
        }

        tabButtons.forEach(button => {
            button.addEventListener('click', (e) => {
                e.preventDefault();
                const targetTab = button.getAttribute('data-tab');
                this.switchTab(targetTab, tabButtons, tabContents);
            });
        });
    },

    switchTab(targetTab, tabButtons, tabContents) {
        // Actualizar estado
        this.state.currentTab = targetTab;

        // Remover clase active de todos los botones
        tabButtons.forEach(btn => {
            btn.classList.remove('active');
            btn.setAttribute('aria-selected', 'false');
        });

        // Remover clase active de todos los contenidos
        tabContents.forEach(content => {
            content.classList.remove('active');
        });

        // Agregar clase active al botn seleccionado
        const activeButton = document.querySelector(`[data-tab="${targetTab}"]`);
        if (activeButton) {
            activeButton.classList.add('active');
            activeButton.setAttribute('aria-selected', 'true');
        }

        // Agregar clase active al contenido correspondiente
        const activeContent = document.getElementById(targetTab);
        if (activeContent) {
            activeContent.classList.add('active');
        }

        console.log(`= Tab cambiado a: ${targetTab}`);
    }
};

// ============================================
// INICIALIZACIN AL CARGAR EL DOM
// ============================================
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', () => AsuntosAcademicos.init());
} else {
    AsuntosAcademicos.init();
}

// ============================================
// MANEJO DE ERRORES ESPECFICO DEL MDULO
// ============================================
window.addEventListener('error', (event) => {
    if (event.filename && event.filename.includes('scriptAsunAca.js')) {
        console.error('L Error en mdulo Asuntos Acadmicos:', event.error);
    }
});

// ============================================
// EXPORTAR PARA USO EN MDULOS (OPCIONAL)
// ============================================
if (typeof module !== 'undefined' && module.exports) {
    module.exports = AsuntosAcademicos;
}
